#include "stdafx.h"

#ifdef VCLINK_STATIC
	#define hInstVCDLG32 theApp.GetVCDLG32()
#else
	#include "VCType32.h"
	#include "VCDlg32.h"
	extern HMODULE hInstVCDLG32;
#endif

//============== VCAddPlotter ==============
typedef void (CALLBACK* VCAddPlotterFN) (short*, char*);

void WINAPI VCAddPlotter (short* iError, char* szPlotterName)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCAddPlotter");
	if (fp)
	{
		((VCAddPlotterFN)fp)(iError, szPlotterName);
	}
}

//============== VCAddPlotterLanguageName ==============
typedef void (CALLBACK* VCAddPlotterLanguageNameFN) (short*, char*);

void WINAPI VCAddPlotterLanguageName (short* iError, char* szLanguageName)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCAddPlotterLanguageName");
	if (fp)
	{
		((VCAddPlotterLanguageNameFN)fp)(iError, szLanguageName);
	}
}

//============== VCAddPlotterPageSize ==============
typedef void (CALLBACK* VCAddPlotterPageSizeFN) (short*, Point2D*);

void WINAPI VCAddPlotterPageSize (short* iError, Point2D* pPageSize)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCAddPlotterPageSize");
	if (fp)
	{
		((VCAddPlotterPageSizeFN)fp)(iError, pPageSize);
	}
}

//============== VCAddPlotterPenMapName ==============
typedef void (CALLBACK* VCAddPlotterPenMapNameFN) (short*, char*);

void WINAPI VCAddPlotterPenMapName (short* iError, char* szPenMapName)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCAddPlotterPenMapName");
	if (fp)
	{
		((VCAddPlotterPenMapNameFN)fp)(iError, szPenMapName);
	}
}

//============== VCApplyPlotterLanguageDefaults ==============
typedef void (CALLBACK* VCApplyPlotterLanguageDefaultsFN) (short*);

void WINAPI VCApplyPlotterLanguageDefaults (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCApplyPlotterLanguageDefaults");
	if (fp)
	{
		((VCApplyPlotterLanguageDefaultsFN)fp)(iError);
	}
}

//============== VCApplyPlotterPenMapDefaults ==============
typedef void (CALLBACK* VCApplyPlotterPenMapDefaultsFN) (short*);

void WINAPI VCApplyPlotterPenMapDefaults (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCApplyPlotterPenMapDefaults");
	if (fp)
	{
		((VCApplyPlotterPenMapDefaultsFN)fp)(iError);
	}
}

//============== VCBirdsEye ==============
typedef void (CALLBACK* VCBirdsEyeFN) (short*, short);

void WINAPI VCBirdsEye (short* iError, short iDisplayMode)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCBirdsEye");
	if (fp)
	{
		((VCBirdsEyeFN)fp)(iError, iDisplayMode);
	}
}

//============== VCChangeRefFrameNameDlg ==============
typedef void (CALLBACK* VCChangeRefFrameNameDlgFN) (short*);

void WINAPI VCChangeRefFrameNameDlg (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCChangeRefFrameNameDlg");
	if (fp)
	{
		((VCChangeRefFrameNameDlgFN)fp)(iError);
	}
}

//============== VCChangeRibalog ==============
typedef void (CALLBACK* VCChangeRibalogFN) (void);

void WINAPI VCChangeRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCChangeRibalog");
	if (fp)
	{
		((VCChangeRibalogFN)fp)();
	}
}

//============== VCCloseRibalog ==============
typedef void (CALLBACK* VCCloseRibalogFN) (short*);

void WINAPI VCCloseRibalog (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCCloseRibalog");
	if (fp)
	{
		((VCCloseRibalogFN)fp)(iError);
	}
}

//============== VCDBLineSettingsRibalog ==============
typedef void (CALLBACK* VCDBLineSettingsRibalogFN) (void);

void WINAPI VCDBLineSettingsRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCDBLineSettingsRibalog");
	if (fp)
	{
		((VCDBLineSettingsRibalogFN)fp)();
	}
}

//============== VCDeInitPrintMode ==============
typedef void (CALLBACK* VCDeInitPrintModeFN) (short*);

void WINAPI VCDeInitPrintMode (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCDeInitPrintMode");
	if (fp)
	{
		((VCDeInitPrintModeFN)fp)(iError);
	}
}

//============== VCDimArrowRibalog ==============
typedef void (CALLBACK* VCDimArrowRibalogFN) (void);

void WINAPI VCDimArrowRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCDimArrowRibalog");
	if (fp)
	{
		((VCDimArrowRibalogFN)fp)();
	}
}

//============== VCDimDisplayRibalog ==============
typedef void (CALLBACK* VCDimDisplayRibalogFN) (void);

void WINAPI VCDimDisplayRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCDimDisplayRibalog");
	if (fp)
	{
		((VCDimDisplayRibalogFN)fp)();
	}
}

//============== VCDimExtRibalog ==============
typedef void (CALLBACK* VCDimExtRibalogFN) (void);

void WINAPI VCDimExtRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCDimExtRibalog");
	if (fp)
	{
		((VCDimExtRibalogFN)fp)();
	}
}

//============== VCDimLeaderRibalog ==============
typedef void (CALLBACK* VCDimLeaderRibalogFN) (void);

void WINAPI VCDimLeaderRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCDimLeaderRibalog");
	if (fp)
	{
		((VCDimLeaderRibalogFN)fp)();
	}
}

//============== VCDimLineRibalog ==============
typedef void (CALLBACK* VCDimLineRibalogFN) (void);

void WINAPI VCDimLineRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCDimLineRibalog");
	if (fp)
	{
		((VCDimLineRibalogFN)fp)();
	}
}

//============== VCDimStringsRibalog ==============
typedef void (CALLBACK* VCDimStringsRibalogFN) (void);

void WINAPI VCDimStringsRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCDimStringsRibalog");
	if (fp)
	{
		((VCDimStringsRibalogFN)fp)();
	}
}

//============== VCDimTextRibalog ==============
typedef void (CALLBACK* VCDimTextRibalogFN) (void);

void WINAPI VCDimTextRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCDimTextRibalog");
	if (fp)
	{
		((VCDimTextRibalogFN)fp)();
	}
}

//============== VCDimToleranceRibalog ==============
typedef void (CALLBACK* VCDimToleranceRibalogFN) (void);

void WINAPI VCDimToleranceRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCDimToleranceRibalog");
	if (fp)
	{
		((VCDimToleranceRibalogFN)fp)();
	}
}

//============== VCFilletRadiusRibalog ==============
typedef void (CALLBACK* VCFilletRadiusRibalogFN) (void);

void WINAPI VCFilletRadiusRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCFilletRadiusRibalog");
	if (fp)
	{
		((VCFilletRadiusRibalogFN)fp)();
	}
}

//============== VCFilterRibalog ==============
typedef void (CALLBACK* VCFilterRibalogFN) (void);

void WINAPI VCFilterRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCFilterRibalog");
	if (fp)
	{
		((VCFilterRibalogFN)fp)();
	}
}

//============== VCGetCurrentPrinter ==============
typedef short (CALLBACK* VCGetCurrentPrinterFN) (short*, char*);

short WINAPI VCGetCurrentPrinter (short* iError, char* szPrinter)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetCurrentPrinter");
	if (fp)
	{
		return ((VCGetCurrentPrinterFN)fp)(iError, szPrinter);
	}
	return iRet;
}

//============== VCGetDefaultPrinter ==============
typedef short (CALLBACK* VCGetDefaultPrinterFN) (short*, char*);

short WINAPI VCGetDefaultPrinter (short* iError, char* szDefaultPrinter)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetDefaultPrinter");
	if (fp)
	{
		return ((VCGetDefaultPrinterFN)fp)(iError, szDefaultPrinter);
	}
	return iRet;
}

//============== VCGetMainHMenu ==============
typedef HMENU (CALLBACK* VCGetMainHMenuFN) (void);

HMENU WINAPI VCGetMainHMenu (void)
{
	HMENU iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetMainHMenu");
	if (fp)
	{
		return ((VCGetMainHMenuFN)fp)();
	}
	return iRet;
}

//============== VCGetPlotSettings ==============
typedef void (CALLBACK* VCGetPlotSettingsFN) (short*, PlotStruct*);

void WINAPI VCGetPlotSettings (short* iError, PlotStruct* pSettings)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotSettings");
	if (fp)
	{
		((VCGetPlotSettingsFN)fp)(iError, pSettings);
	}
}

//============== VCGetPlotterCount ==============
typedef short (CALLBACK* VCGetPlotterCountFN) (short*);

short WINAPI VCGetPlotterCount (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterCount");
	if (fp)
	{
		return ((VCGetPlotterCountFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetPlotterCurrentLanguageName ==============
typedef short (CALLBACK* VCGetPlotterCurrentLanguageNameFN) (short*, char*);

short WINAPI VCGetPlotterCurrentLanguageName (short* iError, char* szLanguageName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterCurrentLanguageName");
	if (fp)
	{
		return ((VCGetPlotterCurrentLanguageNameFN)fp)(iError, szLanguageName);
	}
	return iRet;
}

//============== VCGetPlotterCurrentPageSize ==============
typedef void (CALLBACK* VCGetPlotterCurrentPageSizeFN) (short*, short*, Point2D*);

void WINAPI VCGetPlotterCurrentPageSize (short* iError, short* iIndex, Point2D* pPaperSize)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterCurrentPageSize");
	if (fp)
	{
		((VCGetPlotterCurrentPageSizeFN)fp)(iError, iIndex, pPaperSize);
	}
}

//============== VCGetPlotterCurrentPenMapName ==============
typedef short (CALLBACK* VCGetPlotterCurrentPenMapNameFN) (short*, char*);

short WINAPI VCGetPlotterCurrentPenMapName (short* iError, char* szPenMapName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterCurrentPenMapName");
	if (fp)
	{
		return ((VCGetPlotterCurrentPenMapNameFN)fp)(iError, szPenMapName);
	}
	return iRet;
}

//============== VCGetPlotterDeInitString ==============
typedef short (CALLBACK* VCGetPlotterDeInitStringFN) (short*, char*);

short WINAPI VCGetPlotterDeInitString (short* iError, char* sz)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterDeInitString");
	if (fp)
	{
		return ((VCGetPlotterDeInitStringFN)fp)(iError, sz);
	}
	return iRet;
}

//============== VCGetPlotterDelimiter ==============
typedef short (CALLBACK* VCGetPlotterDelimiterFN) (short*, char*);

short WINAPI VCGetPlotterDelimiter (short* iError, char* sz)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterDelimiter");
	if (fp)
	{
		return ((VCGetPlotterDelimiterFN)fp)(iError, sz);
	}
	return iRet;
}

//============== VCGetPlotterInitString ==============
typedef short (CALLBACK* VCGetPlotterInitStringFN) (short*, char*);

short WINAPI VCGetPlotterInitString (short* iError, char* sz)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterInitString");
	if (fp)
	{
		return ((VCGetPlotterInitStringFN)fp)(iError, sz);
	}
	return iRet;
}

//============== VCGetPlotterLanguageCount ==============
typedef short (CALLBACK* VCGetPlotterLanguageCountFN) (short*);

short WINAPI VCGetPlotterLanguageCount (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterLanguageCount");
	if (fp)
	{
		return ((VCGetPlotterLanguageCountFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetPlotterLanguageName ==============
typedef short (CALLBACK* VCGetPlotterLanguageNameFN) (short*, short, char*);

short WINAPI VCGetPlotterLanguageName (short* iError, short iIndex, char* szLanguageName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterLanguageName");
	if (fp)
	{
		return ((VCGetPlotterLanguageNameFN)fp)(iError, iIndex, szLanguageName);
	}
	return iRet;
}

//============== VCGetPlotterPageSize ==============
typedef void (CALLBACK* VCGetPlotterPageSizeFN) (short*, short, Point2D*);

void WINAPI VCGetPlotterPageSize (short* iError, short iIndex, Point2D* pPaperSize)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterPageSize");
	if (fp)
	{
		((VCGetPlotterPageSizeFN)fp)(iError, iIndex, pPaperSize);
	}
}

//============== VCGetPlotterPageSizeCount ==============
typedef short (CALLBACK* VCGetPlotterPageSizeCountFN) (short*);

short WINAPI VCGetPlotterPageSizeCount (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterPageSizeCount");
	if (fp)
	{
		return ((VCGetPlotterPageSizeCountFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetPlotterPenChangeString ==============
typedef short (CALLBACK* VCGetPlotterPenChangeStringFN) (short*, char*);

short WINAPI VCGetPlotterPenChangeString (short* iError, char* sz)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterPenChangeString");
	if (fp)
	{
		return ((VCGetPlotterPenChangeStringFN)fp)(iError, sz);
	}
	return iRet;
}

//============== VCGetPlotterPenDownString ==============
typedef short (CALLBACK* VCGetPlotterPenDownStringFN) (short*, char*);

short WINAPI VCGetPlotterPenDownString (short* iError, char* sz)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterPenDownString");
	if (fp)
	{
		return ((VCGetPlotterPenDownStringFN)fp)(iError, sz);
	}
	return iRet;
}

//============== VCGetPlotterPenDrawString ==============
typedef short (CALLBACK* VCGetPlotterPenDrawStringFN) (short*, char*);

short WINAPI VCGetPlotterPenDrawString (short* iError, char* sz)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterPenDrawString");
	if (fp)
	{
		return ((VCGetPlotterPenDrawStringFN)fp)(iError, sz);
	}
	return iRet;
}

//============== VCGetPlotterPenMapCount ==============
typedef short (CALLBACK* VCGetPlotterPenMapCountFN) (short*);

short WINAPI VCGetPlotterPenMapCount (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterPenMapCount");
	if (fp)
	{
		return ((VCGetPlotterPenMapCountFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetPlotterPenMapName ==============
typedef short (CALLBACK* VCGetPlotterPenMapNameFN) (short*, short, char*);

short WINAPI VCGetPlotterPenMapName (short* iError, short iIndex, char* szPenMapName)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterPenMapName");
	if (fp)
	{
		return ((VCGetPlotterPenMapNameFN)fp)(iError, iIndex, szPenMapName);
	}
	return iRet;
}

//============== VCGetPlotterPenMapping ==============
typedef void (CALLBACK* VCGetPlotterPenMappingFN) (short*, short, short*, double*, short*);

void WINAPI VCGetPlotterPenMapping (short* iError, short iColor, short* iPen, double* dWidth, short* iSpeed)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterPenMapping");
	if (fp)
	{
		((VCGetPlotterPenMappingFN)fp)(iError, iColor, iPen, dWidth, iSpeed);
	}
}

//============== VCGetPlotterPenMoveString ==============
typedef short (CALLBACK* VCGetPlotterPenMoveStringFN) (short*, char*);

short WINAPI VCGetPlotterPenMoveString (short* iError, char* sz)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterPenMoveString");
	if (fp)
	{
		return ((VCGetPlotterPenMoveStringFN)fp)(iError, sz);
	}
	return iRet;
}

//============== VCGetPlotterPenSpeedString ==============
typedef short (CALLBACK* VCGetPlotterPenSpeedStringFN) (short*, char*);

short WINAPI VCGetPlotterPenSpeedString (short* iError, char* sz)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterPenSpeedString");
	if (fp)
	{
		return ((VCGetPlotterPenSpeedStringFN)fp)(iError, sz);
	}
	return iRet;
}

//============== VCGetPlotterPenUpString ==============
typedef short (CALLBACK* VCGetPlotterPenUpStringFN) (short*, char*);

short WINAPI VCGetPlotterPenUpString (short* iError, char* sz)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPlotterPenUpString");
	if (fp)
	{
		return ((VCGetPlotterPenUpStringFN)fp)(iError, sz);
	}
	return iRet;
}

//============== VCGetPrintSettings ==============
typedef void (CALLBACK* VCGetPrintSettingsFN) (short*, PrintStruct*);

void WINAPI VCGetPrintSettings (short* iError, PrintStruct* pSettings)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPrintSettings");
	if (fp)
	{
		((VCGetPrintSettingsFN)fp)(iError, pSettings);
	}
}

//============== VCGetPrinterName ==============
typedef short (CALLBACK* VCGetPrinterNameFN) (short*, short, char*);

short WINAPI VCGetPrinterName (short* iError, short iIndex, char* szPrinter)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPrinterName");
	if (fp)
	{
		return ((VCGetPrinterNameFN)fp)(iError, iIndex, szPrinter);
	}
	return iRet;
}

//============== VCGetPrinterNameCount ==============
typedef short (CALLBACK* VCGetPrinterNameCountFN) (short*);

short WINAPI VCGetPrinterNameCount (short* iError)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetPrinterNameCount");
	if (fp)
	{
		return ((VCGetPrinterNameCountFN)fp)(iError);
	}
	return iRet;
}

//============== VCGetRibalogSize ==============
typedef void (CALLBACK* VCGetRibalogSizeFN) (short*, iPoint2D*, iPoint2D*);

void WINAPI VCGetRibalogSize (short* iError, iPoint2D* ipOrg, iPoint2D* ipSize)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetRibalogSize");
	if (fp)
	{
		((VCGetRibalogSizeFN)fp)(iError, ipOrg, ipSize);
	}
}

//============== VCGetSpecificPrinter ==============
typedef short (CALLBACK* VCGetSpecificPrinterFN) (short*, char*);

short WINAPI VCGetSpecificPrinter (short* iError, char* szSpecificPrinter)
{
	short iRet;
	iRet = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetSpecificPrinter");
	if (fp)
	{
		return ((VCGetSpecificPrinterFN)fp)(iError, szSpecificPrinter);
	}
	return iRet;
}

//============== VCGetStatusBarSize ==============
typedef void (CALLBACK* VCGetStatusBarSizeFN) (short*, iPoint2D*, iPoint2D*);

void WINAPI VCGetStatusBarSize (short* iError, iPoint2D* ipOrg, iPoint2D* ipSize)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetStatusBarSize");
	if (fp)
	{
		((VCGetStatusBarSizeFN)fp)(iError, ipOrg, ipSize);
	}
}

//============== VCGetToolbar ==============
typedef HWND (CALLBACK* VCGetToolbarFN) (short);

HWND WINAPI VCGetToolbar (short i)
{
	HWND hWnd;
	hWnd = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetToolbar");
	if (fp)
	{
		return ((VCGetToolbarFN)fp)(i);
	}
	return hWnd;
}

//============== VCGetTopTool ==============
typedef HWND (CALLBACK* VCGetTopToolFN) (void);

HWND WINAPI VCGetTopTool (void)
{
	HWND hWnd;
	hWnd = 0;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetTopTool");
	if (fp)
	{
		return ((VCGetTopToolFN)fp)();
	}
	return hWnd;
}

//============== VCGetUseHPGL2 ==============
typedef vbool (CALLBACK* VCGetUseHPGL2FN) (short*);

vbool WINAPI VCGetUseHPGL2 (short* iError)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetUseHPGL2");
	if (fp)
	{
		return ((VCGetUseHPGL2FN)fp)(iError);
	}
	return vbRet;
}

//============== VCHatchSettingsRibalog ==============
typedef void (CALLBACK* VCHatchSettingsRibalogFN) (void);

void WINAPI VCHatchSettingsRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCHatchSettingsRibalog");
	if (fp)
	{
		((VCHatchSettingsRibalogFN)fp)();
	}
}

//============== VCInitDialogs ==============
typedef void (CALLBACK* VCInitDialogsFN) (void);

void WINAPI VCInitDialogs (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCInitDialogs");
	if (fp)
	{
		((VCInitDialogsFN)fp)();
	}
}

//============== VCInitPrintMode ==============
typedef void (CALLBACK* VCInitPrintModeFN) (short*, short);

void WINAPI VCInitPrintMode (short* iError, short iPrintMode)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCInitPrintMode");
	if (fp)
	{
		((VCInitPrintModeFN)fp)(iError, iPrintMode);
	}
}

//============== VCLayerMgr ==============
typedef void (CALLBACK* VCLayerMgrFN) (short*);

void WINAPI VCLayerMgr (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCLayerMgr");
	if (fp)
	{
		((VCLayerMgrFN)fp)(iError);
	}
}

//============== VCLoadAlias ==============
typedef void (CALLBACK* VCLoadAliasFN) (char*, short*);

void WINAPI VCLoadAlias (char* szFile, short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCLoadAlias");
	if (fp)
	{
		((VCLoadAliasFN)fp)(szFile, iError);
	}
}

//============== VCLoadCmdExt ==============
typedef void (CALLBACK* VCLoadCmdExtFN) (char*, short*);

void WINAPI VCLoadCmdExt (char* szFile, short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCLoadCmdExt");
	if (fp)
	{
		((VCLoadCmdExtFN)fp)(szFile, iError);
	}
}

//============== VCLoadMainSpeedbar ==============
typedef void (CALLBACK* VCLoadMainSpeedbarFN) (char*, short*);

void WINAPI VCLoadMainSpeedbar (char* szFile, short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCLoadMainSpeedbar");
	if (fp)
	{
		((VCLoadMainSpeedbarFN)fp)(szFile, iError);
	}
}

//============== VCLoadPlotterDriver ==============
typedef void (CALLBACK* VCLoadPlotterDriverFN) (short*, char*);

void WINAPI VCLoadPlotterDriver (short* iError, char* szName)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCLoadPlotterDriver");
	if (fp)
	{
		((VCLoadPlotterDriverFN)fp)(iError, szName);
	}
}

//============== VCLoadPlotterLanguage ==============
typedef void (CALLBACK* VCLoadPlotterLanguageFN) (short*, char*);

void WINAPI VCLoadPlotterLanguage (short* iError, char* szName)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCLoadPlotterLanguage");
	if (fp)
	{
		((VCLoadPlotterLanguageFN)fp)(iError, szName);
	}
}

//============== VCLoadPlotterPenMap ==============
typedef void (CALLBACK* VCLoadPlotterPenMapFN) (short*, char*);

void WINAPI VCLoadPlotterPenMap (short* iError, char* szName)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCLoadPlotterPenMap");
	if (fp)
	{
		((VCLoadPlotterPenMapFN)fp)(iError, szName);
	}
}

//============== VCLoadToolPalette ==============
typedef void (CALLBACK* VCLoadToolPaletteFN) (char*, short*);

void WINAPI VCLoadToolPalette (char* szFile, short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCLoadToolPalette");
	if (fp)
	{
		((VCLoadToolPaletteFN)fp)(szFile, iError);
	}
}

//============== VCMeasureAngleRibalog ==============
typedef void (CALLBACK* VCMeasureAngleRibalogFN) (void);

void WINAPI VCMeasureAngleRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCMeasureAngleRibalog");
	if (fp)
	{
		((VCMeasureAngleRibalogFN)fp)();
	}
}

//============== VCMeasureAreaRibalog ==============
typedef void (CALLBACK* VCMeasureAreaRibalogFN) (void);

void WINAPI VCMeasureAreaRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCMeasureAreaRibalog");
	if (fp)
	{
		((VCMeasureAreaRibalogFN)fp)();
	}
}

//============== VCMeasureDistRibalog ==============
typedef void (CALLBACK* VCMeasureDistRibalogFN) (void);

void WINAPI VCMeasureDistRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCMeasureDistRibalog");
	if (fp)
	{
		((VCMeasureDistRibalogFN)fp)();
	}
}

//============== VCModalDlg ==============
typedef void (CALLBACK* VCModalDlgFN) (short*, long);

void WINAPI VCModalDlg (short* iError, long cmd_id)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCModalDlg");
	if (fp)
	{
		((VCModalDlgFN)fp)(iError, cmd_id);
	}
}

//============== VCNoDrawingSpeedbar ==============
typedef void (CALLBACK* VCNoDrawingSpeedbarFN) (short*);

void WINAPI VCNoDrawingSpeedbar (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCNoDrawingSpeedbar");
	if (fp)
	{
		((VCNoDrawingSpeedbarFN)fp)(iError);
	}
}

//============== VCObjectInfo ==============
typedef void (CALLBACK* VCObjectInfoFN) (short*);

void WINAPI VCObjectInfo (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCObjectInfo");
	if (fp)
	{
		((VCObjectInfoFN)fp)(iError);
	}
}

//============== VCOffsetRibalog ==============
typedef void (CALLBACK* VCOffsetRibalogFN) (void);

void WINAPI VCOffsetRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCOffsetRibalog");
	if (fp)
	{
		((VCOffsetRibalogFN)fp)();
	}
}

//============== VCOrthoAngleRibalog ==============
typedef void (CALLBACK* VCOrthoAngleRibalogFN) (void);

void WINAPI VCOrthoAngleRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCOrthoAngleRibalog");
	if (fp)
	{
		((VCOrthoAngleRibalogFN)fp)();
	}
}

//============== VCPlot ==============
typedef void (CALLBACK* VCPlotFN) (short*);

void WINAPI VCPlot (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCPlot");
	if (fp)
	{
		((VCPlotFN)fp)(iError);
	}
}

//============== VCPlotDlg ==============
typedef void (CALLBACK* VCPlotDlgFN) (short*);

void WINAPI VCPlotDlg (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCPlotDlg");
	if (fp)
	{
		((VCPlotDlgFN)fp)(iError);
	}
}

//============== VCPrint ==============
typedef void (CALLBACK* VCPrintFN) (short*);

void WINAPI VCPrint (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCPrint");
	if (fp)
	{
		((VCPrintFN)fp)(iError);
	}
}

//============== VCPrintDlg ==============
typedef void (CALLBACK* VCPrintDlgFN) (short*);

void WINAPI VCPrintDlg (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCPrintDlg");
	if (fp)
	{
		((VCPrintDlgFN)fp)(iError);
	}
}

//============== VCPropertiesRibalog ==============
typedef void (CALLBACK* VCPropertiesRibalogFN) (void);

void WINAPI VCPropertiesRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCPropertiesRibalog");
	if (fp)
	{
		((VCPropertiesRibalogFN)fp)();
	}
}

//============== VCRFBirdsEye ==============
typedef void (CALLBACK* VCRFBirdsEyeFN) (short*);

void WINAPI VCRFBirdsEye (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCRFBirdsEye");
	if (fp)
	{
		((VCRFBirdsEyeFN)fp)(iError);
	}
}

//============== VCRFLayerMgr ==============
typedef void (CALLBACK* VCRFLayerMgrFN) (short*);

void WINAPI VCRFLayerMgr (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCRFLayerMgr");
	if (fp)
	{
		((VCRFLayerMgrFN)fp)(iError);
	}
}

//============== VCRIsButtonDown ==============
typedef vbool (CALLBACK* VCRIsButtonDownFN) (short*, char*, WORD);

vbool WINAPI VCRIsButtonDown (short* iError, char* szNative, WORD id)
{
	vbool vbRet;
	vbRet = FALSE;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCRIsButtonDown");
	if (fp)
	{
		return ((VCRIsButtonDownFN)fp)(iError, szNative, id);
	}
	return vbRet;
}

//============== VCRemovePlotterPageSize ==============
typedef void (CALLBACK* VCRemovePlotterPageSizeFN) (short*, short);

void WINAPI VCRemovePlotterPageSize (short* iError, short iIndex)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCRemovePlotterPageSize");
	if (fp)
	{
		((VCRemovePlotterPageSizeFN)fp)(iError, iIndex);
	}
}

//============== VCResetCmdExt ==============
typedef void (CALLBACK* VCResetCmdExtFN) (short*);

void WINAPI VCResetCmdExt (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCResetCmdExt");
	if (fp)
	{
		((VCResetCmdExtFN)fp)(iError);
	}
}

//============== VCResetPrintMargins ==============
typedef void (CALLBACK* VCResetPrintMarginsFN) (short*);

void WINAPI VCResetPrintMargins (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCResetPrintMargins");
	if (fp)
	{
		((VCResetPrintMarginsFN)fp)(iError);
	}
}

//============== VCSavePlotterDriver ==============
typedef void (CALLBACK* VCSavePlotterDriverFN) (short*, char*);

void WINAPI VCSavePlotterDriver (short* iError, char* szName)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSavePlotterDriver");
	if (fp)
	{
		((VCSavePlotterDriverFN)fp)(iError, szName);
	}
}

//============== VCSavePlotterLanguage ==============
typedef void (CALLBACK* VCSavePlotterLanguageFN) (short*, char*);

void WINAPI VCSavePlotterLanguage (short* iError, char* szName)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSavePlotterLanguage");
	if (fp)
	{
		((VCSavePlotterLanguageFN)fp)(iError, szName);
	}
}

//============== VCSavePlotterPenMap ==============
typedef void (CALLBACK* VCSavePlotterPenMapFN) (short*, char*);

void WINAPI VCSavePlotterPenMap (short* iError, char* szName)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSavePlotterPenMap");
	if (fp)
	{
		((VCSavePlotterPenMapFN)fp)(iError, szName);
	}
}

//============== VCScriptAssignRibalog ==============
typedef void (CALLBACK* VCScriptAssignRibalogFN) (void);

void WINAPI VCScriptAssignRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCScriptAssignRibalog");
	if (fp)
	{
		((VCScriptAssignRibalogFN)fp)();
	}
}

//============== VCSetDefaultPrinter ==============
typedef void (CALLBACK* VCSetDefaultPrinterFN) (short*, char*);

void WINAPI VCSetDefaultPrinter (short* iError, char* szDefaultPrinter)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetDefaultPrinter");
	if (fp)
	{
		((VCSetDefaultPrinterFN)fp)(iError, szDefaultPrinter);
	}
}

//============== VCSetDialogFrameHwnd ==============
typedef void (CALLBACK* VCSetDialogFrameHwndFN) (HWND);

void WINAPI VCSetDialogFrameHwnd (HWND hWndFrame)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetDialogFrameHwnd");
	if (fp)
	{
		((VCSetDialogFrameHwndFN)fp)(hWndFrame);
	}
}

//============== VCSetEmbedded ==============
typedef void (CALLBACK* VCSetEmbeddedFN) (vbool);

void WINAPI VCSetEmbedded (vbool tfEmbedded)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetEmbedded");
	if (fp)
	{
		((VCSetEmbeddedFN)fp)(tfEmbedded);
	}
}

//============== VCSetPlotSettings ==============
typedef void (CALLBACK* VCSetPlotSettingsFN) (short*, PlotStruct*);

void WINAPI VCSetPlotSettings (short* iError, PlotStruct* pSettings)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotSettings");
	if (fp)
	{
		((VCSetPlotSettingsFN)fp)(iError, pSettings);
	}
}

//============== VCSetPlotterCurrentLanguageIndex ==============
typedef void (CALLBACK* VCSetPlotterCurrentLanguageIndexFN) (short*, short);

void WINAPI VCSetPlotterCurrentLanguageIndex (short* iError, short iIndex)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotterCurrentLanguageIndex");
	if (fp)
	{
		((VCSetPlotterCurrentLanguageIndexFN)fp)(iError, iIndex);
	}
}

//============== VCSetPlotterCurrentLanguageName ==============
typedef void (CALLBACK* VCSetPlotterCurrentLanguageNameFN) (short*, char*);

void WINAPI VCSetPlotterCurrentLanguageName (short* iError, char* szLanguageName)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotterCurrentLanguageName");
	if (fp)
	{
		((VCSetPlotterCurrentLanguageNameFN)fp)(iError, szLanguageName);
	}
}

//============== VCSetPlotterCurrentPageSize ==============
typedef void (CALLBACK* VCSetPlotterCurrentPageSizeFN) (short*, short);

void WINAPI VCSetPlotterCurrentPageSize (short* iError, short iIndex)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotterCurrentPageSize");
	if (fp)
	{
		((VCSetPlotterCurrentPageSizeFN)fp)(iError, iIndex);
	}
}

//============== VCSetPlotterCurrentPenMapIndex ==============
typedef void (CALLBACK* VCSetPlotterCurrentPenMapIndexFN) (short*, short);

void WINAPI VCSetPlotterCurrentPenMapIndex (short* iError, short iIndex)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotterCurrentPenMapIndex");
	if (fp)
	{
		((VCSetPlotterCurrentPenMapIndexFN)fp)(iError, iIndex);
	}
}

//============== VCSetPlotterCurrentPenMapName ==============
typedef void (CALLBACK* VCSetPlotterCurrentPenMapNameFN) (short*, char*);

void WINAPI VCSetPlotterCurrentPenMapName (short* iError, char* szPenMapName)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotterCurrentPenMapName");
	if (fp)
	{
		((VCSetPlotterCurrentPenMapNameFN)fp)(iError, szPenMapName);
	}
}

//============== VCSetPlotterDeInitString ==============
typedef void (CALLBACK* VCSetPlotterDeInitStringFN) (short*, char*);

void WINAPI VCSetPlotterDeInitString (short* iError, char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotterDeInitString");
	if (fp)
	{
		((VCSetPlotterDeInitStringFN)fp)(iError, sz);
	}
}

//============== VCSetPlotterDelimiter ==============
typedef void (CALLBACK* VCSetPlotterDelimiterFN) (short*, char*);

void WINAPI VCSetPlotterDelimiter (short* iError, char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotterDelimiter");
	if (fp)
	{
		((VCSetPlotterDelimiterFN)fp)(iError, sz);
	}
}

//============== VCSetPlotterInitString ==============
typedef void (CALLBACK* VCSetPlotterInitStringFN) (short*, char*);

void WINAPI VCSetPlotterInitString (short* iError, char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotterInitString");
	if (fp)
	{
		((VCSetPlotterInitStringFN)fp)(iError, sz);
	}
}

//============== VCSetPlotterPenChangeString ==============
typedef void (CALLBACK* VCSetPlotterPenChangeStringFN) (short*, char*);

void WINAPI VCSetPlotterPenChangeString (short* iError, char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotterPenChangeString");
	if (fp)
	{
		((VCSetPlotterPenChangeStringFN)fp)(iError, sz);
	}
}

//============== VCSetPlotterPenDownString ==============
typedef void (CALLBACK* VCSetPlotterPenDownStringFN) (short*, char*);

void WINAPI VCSetPlotterPenDownString (short* iError, char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotterPenDownString");
	if (fp)
	{
		((VCSetPlotterPenDownStringFN)fp)(iError, sz);
	}
}

//============== VCSetPlotterPenDrawString ==============
typedef void (CALLBACK* VCSetPlotterPenDrawStringFN) (short*, char*);

void WINAPI VCSetPlotterPenDrawString (short* iError, char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotterPenDrawString");
	if (fp)
	{
		((VCSetPlotterPenDrawStringFN)fp)(iError, sz);
	}
}

//============== VCSetPlotterPenMapping ==============
typedef void (CALLBACK* VCSetPlotterPenMappingFN) (short*, short, short, double, short);

void WINAPI VCSetPlotterPenMapping (short* iError, short iColor, short iPen, double dWidth, short iSpeed)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotterPenMapping");
	if (fp)
	{
		((VCSetPlotterPenMappingFN)fp)(iError, iColor, iPen, dWidth, iSpeed);
	}
}

//============== VCSetPlotterPenMoveString ==============
typedef void (CALLBACK* VCSetPlotterPenMoveStringFN) (short*, char*);

void WINAPI VCSetPlotterPenMoveString (short* iError, char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotterPenMoveString");
	if (fp)
	{
		((VCSetPlotterPenMoveStringFN)fp)(iError, sz);
	}
}

//============== VCSetPlotterPenSpeedString ==============
typedef void (CALLBACK* VCSetPlotterPenSpeedStringFN) (short*, char*);

void WINAPI VCSetPlotterPenSpeedString (short* iError, char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotterPenSpeedString");
	if (fp)
	{
		((VCSetPlotterPenSpeedStringFN)fp)(iError, sz);
	}
}

//============== VCSetPlotterPenUpString ==============
typedef void (CALLBACK* VCSetPlotterPenUpStringFN) (short*, char*);

void WINAPI VCSetPlotterPenUpString (short* iError, char* sz)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPlotterPenUpString");
	if (fp)
	{
		((VCSetPlotterPenUpStringFN)fp)(iError, sz);
	}
}

//============== VCSetPrintSettings ==============
typedef void (CALLBACK* VCSetPrintSettingsFN) (short*, PrintStruct*);

void WINAPI VCSetPrintSettings (short* iError, PrintStruct* pSettings)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetPrintSettings");
	if (fp)
	{
		((VCSetPrintSettingsFN)fp)(iError, pSettings);
	}
}

//============== VCSetRefFrameNameDlg ==============
typedef void (CALLBACK* VCSetRefFrameNameDlgFN) (short*);

void WINAPI VCSetRefFrameNameDlg (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetRefFrameNameDlg");
	if (fp)
	{
		((VCSetRefFrameNameDlgFN)fp)(iError);
	}
}

//============== VCSetSpecificPrinter ==============
typedef void (CALLBACK* VCSetSpecificPrinterFN) (short*, char*);

void WINAPI VCSetSpecificPrinter (short* iError, char* szSpecificPrinter)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetSpecificPrinter");
	if (fp)
	{
		((VCSetSpecificPrinterFN)fp)(iError, szSpecificPrinter);
	}
}

//============== VCSetUseHPGL2 ==============
typedef void (CALLBACK* VCSetUseHPGL2FN) (short*, vbool);

void WINAPI VCSetUseHPGL2 (short* iError, vbool tf)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSetUseHPGL2");
	if (fp)
	{
		((VCSetUseHPGL2FN)fp)(iError, tf);
	}
}

//============== VCSymCreateRibalog ==============
typedef void (CALLBACK* VCSymCreateRibalogFN) (void);

void WINAPI VCSymCreateRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSymCreateRibalog");
	if (fp)
	{
		((VCSymCreateRibalogFN)fp)();
	}
}

//============== VCSymPlaceRibalog ==============
typedef void (CALLBACK* VCSymPlaceRibalogFN) (void);

void WINAPI VCSymPlaceRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSymPlaceRibalog");
	if (fp)
	{
		((VCSymPlaceRibalogFN)fp)();
	}
}

//============== VCSymbolMgr ==============
typedef void (CALLBACK* VCSymbolMgrFN) (short*);

void WINAPI VCSymbolMgr (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCSymbolMgr");
	if (fp)
	{
		((VCSymbolMgrFN)fp)(iError);
	}
}

//============== VCTerminateDialogs ==============
typedef void (CALLBACK* VCTerminateDialogsFN) (void);

void WINAPI VCTerminateDialogs (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCTerminateDialogs");
	if (fp)
	{
		((VCTerminateDialogsFN)fp)();
	}
}

//============== VCTextLineRibalog ==============
typedef void (CALLBACK* VCTextLineRibalogFN) (void);

void WINAPI VCTextLineRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCTextLineRibalog");
	if (fp)
	{
		((VCTextLineRibalogFN)fp)();
	}
}

//============== VCTextSettingsRibalog ==============
typedef void (CALLBACK* VCTextSettingsRibalogFN) (void);

void WINAPI VCTextSettingsRibalog (void)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCTextSettingsRibalog");
	if (fp)
	{
		((VCTextSettingsRibalogFN)fp)();
	}
}

//============== VCUpdateBirdseyeView ==============
typedef void (CALLBACK* VCUpdateBirdseyeViewFN) (short*, vbool);

void WINAPI VCUpdateBirdseyeView (short* iError, vbool tfRefresh)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCUpdateBirdseyeView");
	if (fp)
	{
		((VCUpdateBirdseyeViewFN)fp)(iError, tfRefresh);
	}
}

//============== VCUpdateDialog ==============
typedef void (CALLBACK* VCUpdateDialogFN) (short*);

void WINAPI VCUpdateDialog (short* iError)
{
	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCUpdateDialog");
	if (fp)
	{
		((VCUpdateDialogFN)fp)(iError);
	}
}

// New VCADD API calls for V3

//============== VCGetToolbar ==============
//extern "C" HWND WINAPI VCGetDialogFromId(WORD id);
typedef HWND (CALLBACK* VCGetDialogFromIdFN) (WORD);

HWND WINAPI VCGetDialogFromId(WORD id)
{
	HWND hWnd = NULL;

	FARPROC fp = GetProcAddress(hInstVCDLG32 , (LPSTR)"VCGetDialogFromId");
	if (fp)
	{
		return ((VCGetDialogFromIdFN)fp)(id);
	}
	return hWnd;
}
